$(function() {

	var urlvars = getUrlVars();
	var reviewId = parseInt(urlvars['revid'], 10);
	var requestId = parseInt(urlvars['rid'], 10);
	var userId = parseInt(urlvars['userId'], 10);
	var workflowId = parseInt(urlvars['wid'], 10);

	$('textarea#inputMessage').focus();


	$('div.modal-footer').on('click', 'button#submit', function(e) {
		e.preventDefault();
		//require a message
		var inputMessage = $('textarea#inputMessage').val();
		var inputTopic = $('textarea#inputTopic').val();
		if( inputMessage == null || inputMessage === "" ) {
			alert("Please enter a message describing the requested changes.");
		} else if( inputTopic == null || inputTopic === "" ) {
			alert("Please enter a topic describing the requested changes.");
		} else {
		
			var ajaxUrl = '../../dart/changeRequest.json';
			
			var aiMap = {"reviewId":reviewId};
			aiMap['requestId'] = requestId;		
			aiMap['userId'] = userId;		
			aiMap['inputMessage'] = $('textarea#inputMessage').val();
			aiMap['inputTopic'] = $('textarea#inputTopic').val();
			
			aiMap['workflowId'] = workflowId;
	
			// actually, I want this to be synchronous
			$.ajax({
				url:ajaxUrl,
				type:'POST',
				async:false,
				contentType:'application/json',
				dataType:'json',
				data:JSON.stringify(aiMap),
				success:function(data,textStatus,three) {
					if (textStatus === 'success') {
						window.opener.location.href="../dashboard.html";
						
						window.close();
					}
				}
			});
		}
	});
});
	

getUrlVars = function()
{
	var vars = [], hash;
	var hashes = window.location.href.slice(window.location.href.indexOf('?') + 1).split('&');
	for(var i = 0; i < hashes.length; i++)
	{
	    hash = hashes[i].split('=');
	    vars.push(hash[0]);
	    vars[hash[0]] = hash[1];
	}
	return vars;
}
